/*! \file
 * \brief A FloatingProtectionMessage configures the floating protection for the device.
 *
 * \copyright
 * COPYRIGHT NOTICE: (c) 2021 Neonode Technologies AB. All rights reserved.
 *
 */

#if !defined(MESSAGE_FLOATINGPROTECTIONMESSAGE_FLOATINGPROTECTIONMESSAGE_H) && \
    !defined(CONTAINS_FLOATINGPROTECTIONMESSAGE)

#ifndef ZFORCECOMMON_H
    #error Please include "zForceCommon.h" before this file.
#endif // ZFORCECOMMON_H

/*!
 * \brief This structure represents a floating protection message.
 *
 * This structure represents a message that configures the floating protection settings.
 */
struct FloatingProtectionMessage
{
#endif // !defined(MESSAGE_FLOATINGPROTECTIONMESSAGE.._H) && !defined(CONTAINS_FLOATINGPROTECTIONMESSAGE)
#if !defined(MESSAGE_FLOATINGPROTECTIONMESSAGE_FLOATINGPROTECTIONMESSAGE_H) && \
    !defined(CONTAINS_FLOATINGPROTECTIONMESSAGE)
    #define CONTAINS_MESSAGE
    #include <Message.h>
    #undef CONTAINS_MESSAGE
    bool     Enabled;    //!< Is Floating Protection Enabled??
    bool     HasEnabled; //!< True if the message contained this value.
    uint32_t Time;       //!< Floating Protection time in ms.
    bool     HasTime;    //!< True if the message contained this value.
#endif // !defined(MESSAGE_FLOATINGPROTECTIONMESSAGE.._H) && !defined(CONTAINS_FLOATINGPROTECTIONMESSAGE)
#if !defined(MESSAGE_FLOATINGPROTECTIONMESSAGE_FLOATINGPROTECTIONMESSAGE_H) && \
    !defined(CONTAINS_FLOATINGPROTECTIONMESSAGE)
};

#ifdef __cplusplus
extern "C"
{
#endif // __cplusplus

/*!
 * \brief Internal constructor for FloatingProtectionMessage.
 *
 * Do not use this, but use the Factory creator instead.
 * \n\n
 * On failure, see errno.
 * - ::EOUTOFMEMORY - Out of memory.
 * - ::EINVALIDSIZE - Invalid size.
 *
 * \param messageGroup MessageGroup of Message.
 * \param size If this is used as a base class for another class, set size to
 *             non-zero.
 *
 * \return Pointer to FloatingProtectionMessage.
 */
DLLINTERNAL FloatingProtectionMessage * FloatingProtectionMessage_New (MessageGroup messageGroup, uint32_t size);

#ifdef __cplusplus
}
#endif // __cplusplus

#define MESSAGE_FLOATINGPROTECTIONMESSAGE_FLOATINGPROTECTIONMESSAGE_H
#endif // !defined(MESSAGE_FLOATINGPROTECTIONMESSAGE.._H) && !defined(CONTAINS_FLOATINGPROTECTIONMESSAGE)

