/*! \file
 *
 * \copyright
 * COPYRIGHT NOTICE: (c) 2017 Neonode Technologies AB. All rights reserved.
 *
 */
#ifndef ZFORCETYPES_H
#define ZFORCETYPES_H

#ifdef COMPILING_ZFORCE_SDK
typedef struct zForceHandler zForceHandler;
#endif
typedef struct zForce zForce;
typedef struct Connection Connection;
typedef struct Device Device;
typedef struct PlatformDevice PlatformDevice;
typedef struct SensorDevice SensorDevice;
typedef struct CoreDevice CoreDevice;
typedef struct AirDevice AirDevice;
typedef struct PlusDevice PlusDevice;
typedef struct LightingDevice LightingDevice;
typedef struct Protocol Protocol;
typedef struct ProtocolEntry ProtocolEntry;
typedef struct Transport Transport;
typedef struct TransportEntry TransportEntry;
typedef struct DataFrame DataFrame;
typedef struct StreamingDataFrame StreamingDataFrame;
// Message
typedef struct Message Message;
typedef struct EnableMessage EnableMessage;
typedef struct DisableMessage DisableMessage;
typedef struct OperationModesMessage OperationModesMessage;
typedef struct ResolutionMessage ResolutionMessage;
typedef struct TouchActiveAreaMessage TouchActiveAreaMessage;
typedef struct TouchMessage TouchMessage;
typedef struct NumberOfTrackedObjectsMessage NumberOfTrackedObjectsMessage;
typedef struct FingerFrequencyMessage FingerFrequencyMessage;
typedef struct IdleFrequencyMessage IdleFrequencyMessage;
typedef struct DetectedObjectSizeRestrictionMessage
                                      DetectedObjectSizeRestrictionMessage;

typedef enum DeviceType DeviceType;
enum DeviceType
{
    None = 0,
    Platform = 1,
    Sensor = 2,
    Core = 4,
    Air = 8,
    Plus = 16,
    Lighting = 32
};

typedef enum MessageType MessageType;
enum MessageType
{
    EnableMessageType,
    DisableMessageType,
    OperationModesMessageType,
    ResolutionMessageType,
    TouchActiveAreaMessageType,
    TouchMessageType,
    DetectedObjectSizeRestrictionMessageType,
    NumberOfTrackedObjectsMessageType,
    FingerFrequencyMessageType,
    IdleFrequencyMessageType,
    HighestValidMessageType = IdleFrequencyMessageType
};

typedef enum MessageGroup MessageGroup;
enum MessageGroup
{
    Request,
    Response,
    Notification,
    HighestValidMessageGroup = Notification
};

typedef enum MessageAction MessageAction;
enum MessageAction
{
    GetAction,   //!< Get information from device.
    SetAction    //!< Set information on device.
};

typedef enum OperationModes OperationModes;
enum OperationModes
{
    NoOperationMode = 0,  //!< No Mode set.
    DetectionMode = 1,    //!< Detection Mode (Touch).
    SignalsMode = 2,      //!< Signals Mode.
    LedLevelsMode = 4,    //!< Led Levels Mode.
    DetectionHidMode = 8, //!< Detection Mode for Hid Devices.
    GesturesMode = 16,    //!< Gestures Mode.
    //! Special value used for error checking.
    HighestValidOperationMode = (GesturesMode * 2) - 1
};

typedef enum TouchEvent TouchEvent;
enum TouchEvent
{
    DownEvent,    //!< New Touch object detected.
    MoveEvent,    //!< The Touch object is moving.
    UpEvent,      //!< The Touch object is no longer detected.
    InvalidEvent, //!< Invalid Touch event reported by Device.
    GhostEvent    //!< Ghost touch detected.
};

typedef enum TouchOrientation TouchOrientation;
enum TouchOrientation
{
    PortraitOrientation, //!< Object is in Portrait orientation.
    LandscapeOrientation //!< Object is in Landscape orientation.
};

typedef struct CartesianCoordinates CartesianCoordinates;
struct CartesianCoordinates
{
    uint32_t X;
    bool     HasX;
    uint32_t Y;
    bool     HasY;
    uint32_t Z;
    bool     HasZ;
};

typedef struct TouchActiveArea TouchActiveArea;
struct TouchActiveArea
{
    uint32_t LowerBoundaryX;
    uint32_t UpperBoundaryX;
    bool     HasX;
    bool     XIsReversed;
    uint32_t LowerBoundaryY;
    uint32_t UpperBoundaryY;
    bool     HasY;
    bool     YIsReversed;
};

#endif // ZFORCETYPES_H
