/*! \file
 * \brief Transport module to connect to devices over Hid Pipe.
 *
 * Allows connections to devices using Hid Pipe.
 *
 * \copyright
 * COPYRIGHT NOTICE: (c) 2017 Neonode Technologies AB. All rights reserved.
 *
 */

#ifndef TRANSPORT_HIDPIPETRANSPORT_HIDPIPETRANSPORT_H
#define TRANSPORT_HIDPIPETRANSPORT_HIDPIPETRANSPORT_H

#ifndef ZFORCECOMMON_H
    #error Please include "zForceCommon.h" before this file.
#endif // ZFORCECOMMON_H

/*!
 * \sa struct HidPipeTransport
 */
typedef struct HidPipeTransport HidPipeTransport;
/*!
 * \brief Struct containing the HidPipeTransport information.
 *
 * HidPipeTransport contains the Transport base, a pointer to the base Transport
 * class.
 *
 */
struct HidPipeTransport
{
    Transport;       //!< The base Transport.
    void * Private;  //!< Private members of HidPipeTransport.
};

DLLINTERNAL bool HidPipeTransport_AddHidPipeTransportEntry (void);

#endif // TRANSPORT_HIDPIPETRANSPORT_HIDPIPETRANSPORT_H

