/*! \file
 * \brief Serial Transport class.
 *
 * This module implements the Serial Transport class. Here we find all that is
 * essential for a Serial Transport.
 *
 * \copyright
 * COPYRIGHT NOTICE: (c) 2017 Neonode Technologies AB. All rights reserved.
 *
 */

#ifndef TRANSPORT_SERIALTRANSPORT_SERIALTRANSPORT_H
#define TRANSPORT_SERIALTRANSPORT_SERIALTRANSPORT_H

#ifndef ZFORCECOMMON_H
    #error Please include "zForceCommon.h" before this file.
#endif // ZFORCECOMMON_H

/*!
 * \sa struct SerialTransport
 */
typedef struct SerialTransport SerialTransport;
/*!
 * \brief Struct containing the SerialTransport information.
 *
 * SerialTransport contains the Transport base, a pointer to the base Transport
 * class.
 *
 */
struct SerialTransport
{
    Transport; //!< The base Transport.
    int FileDescriptor; //!< Instance-specific file descriptor.
};

DLLINTERNAL bool SerialTransport_AddSerialTransportEntry (void);

#define RECEIVEBUFFERSIZE 128

#endif // TRANSPORT_SERIALTRANSPORT_SERIALTRANSPORT_H

